
rm(list=ls())
library(effectsize) # install.packages("effectsize", repos = "https://easystats.r-universe.dev/")

#sink('analysis-output.txt') // Remove from comments to save output to a file

data = read.csv("time-task-results.csv", sep=",", header=TRUE, strip.white=TRUE)

# We work with log-normal distributions as they are well-known to better model time distributions which are often skewed.
# So we first log-transform all time measurements : So inferences apply now to median rather than means
# NOTE: Given that our observed distributions do not deviate much from normal, results are very similar even if we worked with normal distributions.
data$ltime = log(data$time)
data$group = data$participant%%2 # We divide participants into two groups based on which system they used first 

# We build the ANOVA model
anovaModel = aov(ltime ~ group*system + Error(factor(participant)), data)
summary = summary(anovaModel)
effect_size = eta_squared(anovaModel)

print("ANOVA Analysis - Main and Interaction effects")
cat("###############################################\n")
print(summary)
cat("###############################################\n\n")

print("Effect sizes")
cat("############################\n")
print(effect_size)

#sink() # Remove from comments to save output to a file

######################################################################################################################
# An alternative way of conducting the analysus is using a Linear Mixed-Effect Model. Results will be almost identical 
#library(nlme)
#lmeModel = lme(ltime ~ system*group, random= ~1|participant, data=data)
#summary = anova(lmeModel)
#effect_size = eta_squared(lmeModel)
